<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\System\Connection\Proxy;
use Fastmag\Sync\Model\System\Connection\Sql\SqlInterface;

/**
 * Trait FastmagSql
 *
 * Trait for all workers using Fastmag SQL
 */
trait FastmagSql
{
    /** @var Proxy $fastmagSql */
    protected $fastmagSql;

    /** @var SqlInterface $connection */
    protected $connection = false;

    /**
     * Check if the SQL connection to Fastmag is working
     *
     * @return SqlInterface|false
     *
     * @throws NoConnectionException
     */
    protected function getFastmagSqlConnection()
    {
        if ($this->connection === false) {
            $this->connection = $this->fastmagSql->getConnection();
        }

        return $this->connection;
    }
}
