<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-17
 ******************************************************************************/

namespace Fastmag\Sync\Api;

use Fastmag\Sync\Api\Data\LogApiInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface LogApiRepositoryInterface
 */
interface LogApiRepositoryInterface
{
    /**
     * Save log.
     *
     * @param \Fastmag\Sync\Api\Data\LogApiInterface $log
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(LogApiInterface $log);

    /**
     * Retrieve log.
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($logId);

    /**
     * Retrieve logs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\LogApiSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete log.
     *
     * @param \Fastmag\Sync\Api\Data\LogApiInterface $log
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(LogApiInterface $log);

    /**
     * Delete log by ID.
     *
     * @param int $logId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($logId);
}
