<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-10-04
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Customer;

use Exception;
use Fastmag\Sync\Api\CustomerRepositoryInterface as SyncedCustomerRepository;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class Delete
 *
 * Customer synchronization delete action
 */
class Delete extends Action implements HttpPostActionInterface
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::customer_delete';

    /** @var SyncedCustomerRepository $syncedCustomerRepository */
    protected $syncedCustomerRepository;

    /**
     * Delete constructor
     *
     * @param Context                  $context
     * @param SyncedCustomerRepository $syncedCustomerRepository
     */
    public function __construct(
        Context $context,
        SyncedCustomerRepository $syncedCustomerRepository
    ) {
        parent::__construct($context);

        $this->syncedCustomerRepository = $syncedCustomerRepository;
    }

    /**
     * Delete action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $syncId = $this->getRequest()->getParam('id');

        if ($syncId) {
            try {
                $rule = $this->syncedCustomerRepository->getById($syncId);
                $this->syncedCustomerRepository->delete($rule);

                $this->messageManager->addSuccessMessage(__('You deleted the customer mapping.'));
            } catch (Exception $exception) {
                $this->messageManager->addErrorMessage($exception->getMessage());
            }
        } else {
            $this->messageManager->addErrorMessage(__('We can\'t find the mapping to delete.'));
        }

        return $resultRedirect->setPath('*/*/');
    }
}
