<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-10
 ******************************************************************************/

namespace Fastmag\Sync\Logger;

use Fastmag\Sync\Api\LogRepositoryInterface;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\LogFactory;
use Magento\Framework\Exception\LocalizedException;
use Monolog\Handler\HandlerInterface;
use Monolog\Logger as MonologLogger;

/**
 * Class Logger
 *
 * Dedicated logger class
 */
class Logger extends MonologLogger
{
    /** @var Config */
    protected $config;

    /** @var LogFactory */
    protected $logFactory;

    /** @var LogRepositoryInterface */
    protected $logRepository;

    /**
     * Logger constructor.
     *
     * @param string                 $name
     * @param Config                 $config
     * @param LogFactory             $logFactory
     * @param LogRepositoryInterface $logRepository
     * @param HandlerInterface[]     $handlers
     * @param callable[]             $processors
     */
    public function __construct(
        $name,
        Config $config,
        LogFactory $logFactory,
        LogRepositoryInterface $logRepository,
        array $handlers = [],
        array $processors = []
    ) {
        parent::__construct($name, $handlers, $processors);

        $this->config = $config;
        $this->logFactory = $logFactory;
        $this->logRepository = $logRepository;
    }

    /**
     * Log only ERROR, CRITICAL, ALERT, EMERGENCY level log if log disabled in configuration
     *
     * @inheritDoc
     *
     * @throws LocalizedException
     */
    public function addRecord($level, $message, array $context = [])
    {
        if ($level > self::WARNING || $this->config->isSetFlag(Config::XML_PATH_LOG_ENABLE)) {
            $log = $this->logFactory->create();
            $log->setMessage($message)
                ->setLevel($level);

            $this->logRepository->save($log);

            if ($this->config->isSetFlag(Config::XML_PATH_LOG_TO_FILE)) {
                parent::addRecord($level, $message, $context);
            }
        }
    }
}
