<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-11
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Connection;

/**
 * Interface StatusResponseInterface
 */
interface StatusResponseInterface
{
    /** @var string */
    public const API = 'api';

    /** @var string */
    public const EDI = 'edi';

    /** @var string */
    public const MYSQL = 'mysql';

    /**
     * Get API connection status
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusInterface
     */
    public function getApi();

    /**
     * Get EDI connection status
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusInterface
     */
    public function getEdi();

    /**
     * Get MySQL connection status
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusInterface
     */
    public function getMysql();

    /**
     * Set API connection status
     *
     * @param \Fastmag\Sync\Api\Data\Connection\StatusInterface $api
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusResponseInterface
     */
    public function setApi($api);

    /**
     * Set EDI connection status
     *
     * @param \Fastmag\Sync\Api\Data\Connection\StatusInterface $edi
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusResponseInterface
     */
    public function setEdi($edi);

    /**
     * Set MySQL connection status
     *
     * @param \Fastmag\Sync\Api\Data\Connection\StatusInterface $mysql
     *
     * @return \Fastmag\Sync\Api\Data\Connection\StatusResponseInterface
     */
    public function setMysql($mysql);
}
