<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-29
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Rule;

/**
 * Interface PaymentcodeInterface
 */
interface PaymentcodeInterface
{
    /** @var string */
    public const RULE_ID = 'rule_id';

    /** @var string */
    public const PAYMENT_METHOD = 'payment_method';

    /** @var string */
    public const FASTMAG_CODE = 'fastmag_code';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const UPDATED_AT = 'updated_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get payment method
     *
     * @return string|null
     */
    public function getPaymentMethod();

    /**
     * Get Fastmag code
     *
     * @return int|null
     */
    public function getFastmagCode();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get updated at
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Set ID
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface
     */
    public function setId($ruleId);

    /**
     * Set payment method
     *
     * @param string $paymentMethod
     *
     * @return \Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface
     */
    public function setPaymentMethod($paymentMethod);

    /**
     * Set Fastmag code
     *
     * @param int $fastmagCode
     *
     * @return \Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface
     */
    public function setFastmagCode($fastmagCode);
}
