<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-03-25
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Product\Edit\Button;

use Magento\Backend\Block\Widget\Context;
use Magento\Catalog\Api\ProductRepositoryInterface as ProductRepository;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class Resync
 *
 * Class for the button of product resync
 */
class Resync implements ButtonProviderInterface
{
    /** @var Context $context */
    protected $context;

    /** @var ProductRepository ProductRepository */
    protected $productRepository;

    /**
     * Generic constructor
     *
     * @param Context $context
     * @param ProductRepository $productRepository
     */
    public function __construct(Context $context, ProductRepository $productRepository)
    {
        $this->context = $context;
        $this->productRepository = $productRepository;
    }

    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label'      => __('Resync with Fastmag'),
            'on_click'   => sprintf("location.href = '%s';", $this->getResyncUrl()),
            'class'      => 'action-secondary',
            'sort_order' => 100
        ];
    }

    /**
     * Get URL for resync product button
     *
     * @return string
     */
    public function getResyncUrl()
    {
        return $this->getUrl('fastmagsync/catalog_product/resync', ['id' => $this->getProductId()]);
    }

    /**
     * Generate URL by route and parameters
     *
     * @param string $route
     * @param array  $params
     *
     * @return string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }

    /**
     * Return rule ID
     *
     * @return int|null
     */
    public function getProductId()
    {
        try {
            return $this->productRepository->getById($this->context->getRequest()->getParam('id'))->getId();
        } catch (NoSuchEntityException $exception) {
            // No entity
        }

        return null;
    }
}
