<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-06-05
 ******************************************************************************/

namespace Fastmag\Sync\Console;

use Fastmag\Sync\Cron\PushVersion as Cron;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class PushMonitoringCommand
 *
 * Command class for version monitoring tests
 */
class PushMonitoringCommand extends Command
{
    /** @var Cron $cron */
    protected $cron;

    /**
     * SyncRemoteCommand constructor
     *
     * @param Cron        $cron
     * @param string|null $name
     */
    public function __construct(Cron $cron, string $name = 'fastmag-sync:monitorings')
    {
        $this->cron = $cron;

        parent::__construct($name);
    }

    /**
     * @inheritDoc
     *
     * @return void
     */
    protected function configure()
    {
        $this->setDescription('Push module monitoring');

        parent::configure();
    }

    /**
     * @inheritDoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cron->execute();
    }
}
