<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-05
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Order;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Statuses
 *
 * Source for transactions statuses listing filter
 */
class Statuses implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => 'OK', 'label' => 'OK'],
            ['value' => 'KO', 'label' => 'KO'],
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'OK' => 'OK',
            'KO' => 'KO',
        ];
    }
}
