<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-05-31
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Product;

use Fastmag\Sync\Model\Constants;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class NameComposition
 *
 * Source for product name composition config field
 */
class NameComposition implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => Constants::PRODUCT_NAME_COMPOSITION_DESIGNATION, 'label' => __('Designation')],
            ['value' => Constants::PRODUCT_NAME_COMPOSITION_REF_DESIGNATION, 'label' => __('Ref + Designation')],
            [
                'value' => Constants::PRODUCT_NAME_COMPOSITION_DESIGNATION_BIS,
                'label' => __('Designation + Designation Bis')
            ]
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            Constants::PRODUCT_NAME_COMPOSITION_DESIGNATION     => __('Designation'),
            Constants::PRODUCT_NAME_COMPOSITION_REF_DESIGNATION => __('Ref + Designation'),
            Constants::PRODUCT_NAME_COMPOSITION_DESIGNATION_BIS => __('Designation + Designation Bis')
        ];
    }
}
