<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Model\System\Preconfig;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Driver\File as Driver;

/**
 * Class File
 *
 * Class handling the creation and writing of temp file during preconfig phase
 */
class File
{
    /** @var DirectoryList $directoryList */
    protected $directoryList;

    /** @var Filesystem $filesystem */
    protected $filesystem;

    /** @var Driver $driver */
    protected $driver;

    /**
     * FileWriter constructor.
     *
     * @param DirectoryList $directoryList
     * @param Filesystem    $filesystem
     * @param Driver        $driver
     */
    public function __construct(
        DirectoryList $directoryList,
        Filesystem $filesystem,
        Driver $driver
    ) {
        $this->directoryList = $directoryList;
        $this->filesystem = $filesystem;
        $this->driver = $driver;
    }

    /**
     * Write temp file and return path
     *
     * @param string $content
     *
     * @return void
     *
     * @throws FileSystemException
     */
    public function write($content)
    {
        $varDirectory = $this->filesystem->getDirectoryWrite(DirectoryList::VAR_DIR);
        $path = $this->getFilePath();

        $stream = $varDirectory->openFile($path, 'w+');
        $stream->lock();
        $stream->write($content);
        $stream->unlock();
        $stream->close();
    }

    /**
     * Check if temp file exists
     *
     * @return bool
     */
    public function exists()
    {
        try {
            $result = $this->driver->isFile($this->getFilePath());
        } catch (FileSystemException $exception) {
            $result = false;
        }

        return $result;
    }

    /**
     * Check if temp file exists
     *
     * @return void
     *
     * @throws FileSystemException
     */
    public function delete()
    {
        if ($this->exists()) {
            $this->driver->deleteDirectory($this->getDirectoryPath());
        }
    }

    /**
     * Return file path
     *
     * @return string
     *
     * @throws FileSystemException
     */
    protected function getFilePath()
    {
        return $this->directoryList->getPath(DirectoryList::VAR_DIR)
            . DIRECTORY_SEPARATOR . 'fmtmp'. DIRECTORY_SEPARATOR . 'tmp_pass.txt';
    }

    /**
     * Return directory path
     *
     * @return string
     *
     * @throws FileSystemException
     */
    protected function getDirectoryPath()
    {
        return $this->directoryList->getPath(DirectoryList::VAR_DIR) . DIRECTORY_SEPARATOR . 'fmtmp';
    }
}
