<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-20
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento\Integration;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\ToMagento\Integration;
use Fastmag\Sync\Process\Worker\ToMagento\Integration as IntegrationTrait;
use Magento\Customer\Api\AddressRepositoryInterface as AddressRepository;
use Magento\Customer\Api\Data\AddressInterfaceFactory as AddressFactory;
use Magento\Framework\Api\SearchCriteriaBuilder;

/**
 * Class Address
 *
 * Abstract class for Address related Integration workers
 */
abstract class Address extends Worker
{
    use IntegrationTrait;

    /** @var AddressRepository $addressRepository */
    protected $addressRepository;

    /** @var AddressFactory $addressFactory */
    protected $addressFactory;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    public function __construct(
        Logger $logger,
        AddressRepository $addressRepository,
        AddressFactory $addressFactory,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        parent::__construct($logger);

        $this->addressRepository = $addressRepository;
        $this->addressFactory = $addressFactory;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }
}
