<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule;

use Fastmag\Sync\Api\Rule\PaymentcodeRepositoryInterface as RuleRepository;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Request\DataPersistorInterface;

/**
 * Class Paymentcode
 */
abstract class Paymentcode extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::payment_code';

    /** @var DataPersistorInterface $dataPersistor */
    protected $dataPersistor;

    /** @var RuleRepository $ruleRepository */
    protected $ruleRepository;

    /**
     * Paymentcode constructor
     *
     * @param Context                $context
     * @param DataPersistorInterface $dataPersistor
     * @param RuleRepository         $ruleRepository
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        RuleRepository $ruleRepository
    ) {
        parent::__construct($context);

        $this->dataPersistor = $dataPersistor;
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_rule_paymentcode')
            ->addBreadcrumb(__('Rules'), __('Rules'))
            ->addBreadcrumb(__('Payment/Code'), __('Payment/Code'));

        return $resultPage;
    }
}
