<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Model\Constants;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Type;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Quote\Setup\QuoteSetupFactory;
use Magento\Sales\Setup\SalesSetupFactory;
use Zend_Validate_Exception;

/**
 * Class InstallFastmagGencodAttribute
 *
 * Installer for product fastmag_gencod attribute in catalog and sales item
 */
class InstallFastmagGencodAttribute implements DataPatchInterface, PatchRevertableInterface
{
    /** @var ModuleDataSetupInterface $moduleDataSetup */
    protected $moduleDataSetup;

    /** @var EavSetupFactory $eavSetupFactory */
    protected $eavSetupFactory;

    /** @var QuoteSetupFactory */
    protected $quoteSetupFactory;

    /** @var SalesSetupFactory */
    protected $salesSetupFactory;

    /**
     * InstallFastmagGencodAttribute constructor
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory          $eavSetupFactory
     * @param QuoteSetupFactory        $quoteSetupFactory
     * @param SalesSetupFactory        $salesSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory,
        QuoteSetupFactory $quoteSetupFactory,
        SalesSetupFactory $salesSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->quoteSetupFactory = $quoteSetupFactory;
        $this->salesSetupFactory = $salesSetupFactory;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     * @throws Zend_Validate_Exception
     */
    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->addAttribute(
            Product::ENTITY,
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            [
                'label'    => 'Fastmag product ID',
                'type'     => 'int',
                'required' => false,
                'unique'   => true,
                'apply_to' => Type::TYPE_SIMPLE
            ]
        );

        $quoteSetup = $this->quoteSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $quoteSetup->addAttribute(
            'quote_item',
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            ['type' => 'int']
        );

        $salesSetup = $this->salesSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $salesSetup->addAttribute(
            'order_item',
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            ['type' => 'int']
        );
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->removeAttribute(Product::ENTITY, Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);

        $quoteSetup = $this->quoteSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $quoteSetup->removeAttribute('quote_item', Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);

        $salesSetup = $this->salesSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $salesSetup->removeAttribute('quote_item', Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);
    }
}
