<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-04
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Order;

use Magento\Framework\UrlInterface as UrlBuilder;
use Magento\Framework\View\Element\UiComponent\ContextInterface as Context;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class OrderId
 *
 * Column renderer for synced orders increment IDs
 */
class OrderId extends Column
{
    /** @var UrlBuilder $urlBuilder */
    protected $urlBuilder;

    /**
     * OrderId constructor
     *
     * @param Context            $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlBuilder         $urlBuilder
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        Context $context,
        UiComponentFactory $uiComponentFactory,
        UrlBuilder $urlBuilder,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $orderId = $item['order_id'];
        $orderIncrementId = $item['increment_id'];

        return '<a target="_blank" href="'
            . $this->urlBuilder->getUrl('sales/order/view', ['order_id' => $orderId]) . '">'
            . ($orderIncrementId ?? $orderId) . '</a>';
    }
}
