<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Rule;

/**
 * Interface CarrierInterface
 */
interface CarrierInterface
{
    /** @var string */
    public const RULE_ID = 'rule_id';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const UPDATED_AT = 'updated_at';

    /** @var string */
    public const MAGENTO_CODE = 'magento_code';

    /** @var string */
    public const METHOD_CODE = 'method_code';

    /** @var string */
    public const FASTMAG_CODE = 'fastmag_code';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get updated at
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Get Magento carrier code
     *
     * @return string|null
     */
    public function getMagentoCode();

    /**
     * Get Magento shipping method code
     *
     * @return string|null
     */
    public function getMethodCode();

    /**
     * Get Fastmag shipping method code
     *
     * @return string|null
     */
    public function getFastmagCode();

    /**
     * Set ID
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     */
    public function setId($ruleId);

    /**
     * Set Magento carrier code
     *
     * @param string $magentoCode
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     */
    public function setMagentoCode($magentoCode);

    /**
     * Set Magento shipping method code
     *
     * @param string $methodCode
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     */
    public function setMethodCode($methodCode);

    /**
     * Set Fastmag carrier code
     *
     * @param string $fastmagCode
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     */
    public function setFastmagCode($fastmagCode);
}
