<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-15
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory as JobFactory;

/**
 * Class ToFastmag
 *
 * Abstract plugin class for to fastmag jobqueue related processes
 */
abstract class ToFastmag
{
    /** @var JobFactory $jobFactory */
    protected $jobFactory;

    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /** @var Logger $logger */
    protected $logger;

    /** @var Config $config */
    protected $config;

    /**
     * ToFastmag contructor
     *
     * @param JobFactory    $jobFactory
     * @param JobRepository $jobRepository
     * @param Logger        $logger
     * @param Config        $config
     */
    public function __construct(JobFactory $jobFactory, JobRepository $jobRepository, Logger $logger, Config $config)
    {
        $this->jobFactory = $jobFactory;
        $this->jobRepository = $jobRepository;
        $this->logger = $logger;
        $this->config = $config;
    }

    /**
     * Check, in the backtrace, if the order save is called from within the FastmagSync module
     *
     * @return bool
     */
    protected function isCalledByFastmagModule()
    {
        $result = false;

        $trace = debug_backtrace();

        foreach ($trace as $call) {
            if (array_key_exists('class', $call)
                && preg_match('/Fastmag(\\\\)?Sync/', $call['class'])
                && !preg_match('/Fastmag(\\\\)?Sync(\\\\)?Plugin(\\\\)?Jobqueue/', $call['class'])
            ) {
                $result = true;

                break;
            }
        }

        return $result;
    }
}
