# Changelog
All notable changes to this project will be documented in this file.

Additionnaly, you can find it [here](https://www.home-made.io/module-fastmag-sync-magento-2/changelog/).

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Cheatsheet
### Changelog
    Added for new features.
    Changed for changes in existing functionality.
    Deprecated for soon-to-be removed features.
    Removed for now removed features.
    Fixed for any bug fixes.
    Security in case of vulnerabilities.

### Versionning
    MAJOR version when you make incompatible API changes,
    MINOR version when you add functionality in a backwards compatible manner, and
    PATCH version when you make backwards compatible bug fixes.

## Versions
### 1.7.0 – 2023-05-23
#### Added
- Magento 2.4.5 and 2.4.6 compatibility
- PHP 8+ compatibility

#### Changed
- Check payment code existence before trying to sync the order

#### Fixed
- Code review
- Adding Symfony/Console dependency

### 1.6.2 – 2023-03-28
#### Fixed
- Orders synchronization unblocked when several bundle products contain the same simple product

### 1.6.1 – 2023-02-10
#### Fixed
- Product not syncable exception handling in inventory and price workers

### 1.6.0 – 2023-01-27
#### Added
- Handling of extended bundle products from Amasty module

#### Fixed
- Module ConfigurableProduct dependency
- Code review

### 1.5.3 – 2022-12-02
#### Removed
- Hydration limit size config field

#### Fixed
- Check unicity InfosComp Fastmag sales to avoid duplicates when API is in timeout
- Code review

### 1.5.2 – 2022-11-08
#### Fixed
- Area code setting moved from configure to execute of the process queue console class

### 1.5.1 – 2022-10-19
#### Fixed
- Prioritize Fastmag shop on transfer check
- Save single alternative stock as array in order entity
- Quantity round in transfer log message

### 1.5.0 – 2022-10-04
#### Added
- Display source Fastmag shop in sales alerts
- Display products names in Fastmag alerts if config allows it
- Action to delete M2 and Fastmag customers matching
- Specific error message when a Fastmag customer is matched with more than one M2 customer

#### Changed
- Unification of transfers alerts by shop
- Detailed cancellation transfers alerts replaced by generic alerts

#### Fixed
- Products hydration SQL query greatly optimized
- Code review on textile related attribute synchronization

#### Fixed
- Round quantity in transfers and sales alerts

### 1.4.3 – 2022-09-19
#### Fixed
- Stock status synced in products synchronisation, based on salable quantity
- Changed ambiguous "in_stock" variation field as "stock_received"

### 1.4.2 – 2022-09-01
#### Fixed
- Real stock inventory level calculation (minus quantity reserved)

### 1.4.1 – 2022-08-24
#### Fixed
- "excluding_tax" token sent in order synchronization
- Format shipping fees product prices in order synchronization
- Items' comment not sent if empty in order synchronization

### 1.4.0 – 2022-08-23
#### Added
- Do not force product visibility anymore

#### Removed
- Fulltext search on jobs grids

#### Fixed
- "excluding_tax" token sent in order synchronization
- Prefix error when sending customer to Fastmag
- Error when trying to add an attribute option, because of case-sensitive test
- Last and first names of customers sent in uppercase in Fastmag, to allow fonctionnal search
- Test on config fields filling when trying EDI connection
- Filtering and sorting "to Fastmag" jobs grid
- Size and color swatch attributes creation script
- Empty comments on order item
- Invalidate order status jobs when could not ship, instead of skip
- Preconfig script

### 1.3.3 – 2022-10-18
#### Fixed
- Prioritize Fastmag shop on transfer check
- Save single alternative stock as array in order entity
- Quantity round in transfer log message

### 1.3.2 – 2022-09-19
#### Fixed
- Stock status synced in products synchronisation, based on salable quantity
- Changed ambiguous "in_stock" variation field as "stock_received"

### 1.3.1 – 2022-09-01
#### Fixed
- Real stock inventory level calculation (minus quantity reserved)

### 1.3.0 – 2022-06-14
#### Added
- Config field to choose products name composition (ref, designation and designation bis)

#### Changed
- Default attribute set getting optimization in products synchronization
- Source models standardized

#### Fixed
- Fix product synchronization button for configurable products
- Switch sender and recipient shops for transfer alerts
- Unknown job code error handled
- Unique size label now on size and not color
- Monitored data sent correctly
- Addon FastSimpleImport installation added in README

### 1.2.3 – 2022-05-26
#### Fixed
- Deletion of sleeping time before remote queue synchronization

### 1.2.2 – 2022-05-16
#### Fixed
- Wrong dependancy of Sapient/Worldpay for payment data extractor

### 1.2.1 – 2022-05-13
#### Added
- Versions release date on changelog file

#### Fixed
- "Real" inventory level calculation by adding reserved stock from Magento
- Trim of whitespaces in size value on inventory and price synchornization
- Translation of "transfer with AR" config field comment
- Changelog URL

### 1.2.0 – 2022-04-11
#### Added
- Customers import from Fastmag to M2 (only customers not existing in M2)
- GDPR compliant options for customer data deletion : anonymization and deletion
- Check "ping-pong" jobs creation
- Check if jobs are enabled before creation throught plugins in M2
- Resync button on product pages
- Changelog link

#### Changed
- Customers and orders addresses synchronization process
- Plugins naming convention
- Skip of the jobs which are not enabled

#### Fixed
- API timeout exception handling
- Customers synced listing
- Transfers workers logs
- Translations
- Code review

### 1.1.2 – 2022-02-23
#### Added
- Check if products name is not empty before import
- Increment ID and link to order in Synced Orders grid
- Logs in transfers workers
- Logs at the end of the remote queue synchronization process

#### Fixed
- Add a specific suffix on URL key for simple products without size/color (to set a distinction with parent product)
- Reset jobs to Magento when the entity is updated on Fastmag
- Inventory levels request when checking for inventory transfer before syncing orders
- Columns fixed in Synced Orders grid
- PHPMD.CouplingBetweenObjects warning suppression
- Send customer referer to Fastmag only on creation
- Link to edit page on order/transaction rules grid
- Code review

### 1.1.1 – 2022-01-20
#### Fixed
- Clarify comment on "inventory_transfer" config field
- Change field use to set orders' status in Fastmag
- Stock transfers not sent multiple times if order is not synced
- Code review

### 1.1.0 – 2021-12-30
#### Added
- Factory logic to get specific payment ID extractor class depending on payment method of the order synced

#### Fixed
- Code review

### 1.0.2 – 2021-12-20
#### Added
- Add a comment on Fastmag API query on each item which have a discount

#### Fixed
- Substract discount amount to each item total row

### 1.0.1 – 2021-12-02
#### Fixed
- Check order's synchronization history to avoid duplicating transactions in Fastmag when an order is saved in a status defined in Order/Transaction Rules
