<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-05-10
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml;

use Fastmag\Sync\Helper\Email;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

abstract class Preconfig extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::preconfig';

    /** @var Config $config */
    protected Config $config;

    /** @var Logger $logger */
    protected Logger $logger;

    /** @var Email $emailHelper */
    protected Email $emailHelper;

    /**
     * Preconfig constructor
     *
     * @param Context $context
     * @param Config  $config
     * @param Logger  $logger
     * @param Email   $emailHelper
     */
    public function __construct(
        Context $context,
        Config  $config,
        Logger  $logger,
        Email   $emailHelper
    ) {
        parent::__construct($context);

        $this->config = $config;
        $this->logger = $logger;
        $this->emailHelper = $emailHelper;
    }
}
