<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-03-01
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\Collection;
use Fastmag\Sync\Model\System\Connection\Proxy;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\FastmagSql as FastmagSqlTrait;
use Fastmag\Sync\Process\Worker\Hydration as HydrationTrait;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Class Hydration
 *
 * Abstract class inherited by all ToMagento hydration workers
 *
 * @method Collection getJobs()
 */
abstract class Hydration extends Worker
{
    use HydrationTrait;
    use FastmagSqlTrait;

    /**
     * Hydration constructor
     *
     * @param Logger        $logger
     * @param JobRepository $jobRepository
     * @param Config        $config
     * @param Json          $jsonSerializer
     * @param Proxy         $fastmagSql
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Config $config,
        Json $jsonSerializer,
        Proxy $fastmagSql
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->config = $config;
        $this->jsonSerializer = $jsonSerializer;
        $this->fastmagSql = $fastmagSql;
    }

    /**
     * Run the queries to Fastmag through EDI or Direct SQL and returns the data as an array
     *
     * @return array
     */
    abstract protected function getDataFromFastmag();
}
