<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-05
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\System\Connection\Sql\EdiSql as EdiConnector;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Edi
 *
 * EDI connection test action
 */
class Edi extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::config';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var EdiConnector $ediConnector */
    private $ediConnector;

    /** @var Logger $logger */
    protected $logger;

    /**
     * Edi constructor
     *
     * @param Context      $context
     * @param JsonFactory  $resultJsonFactory
     * @param EdiConnector $ediConnector
     * @param Logger       $logger
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        EdiConnector $ediConnector,
        Logger $logger
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->ediConnector = $ediConnector;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $result = ['test_connect' => 0];

        $host = $this->getRequest()->getParam('host');
        $port = $this->getRequest()->getParam('port');
        $chain = $this->getRequest()->getParam('chain');
        $shop = $this->getRequest()->getParam('shop');
        $username = $this->getRequest()->getParam('user');
        $password = $this->getRequest()->getParam('password');
        $ssl = $this->getRequest()->getParam('ssl');

        try {
            $result['test_connect'] = (int) $this->ediConnector
                ->setCredentials($host, $port, $chain, $shop, $username, $password, $ssl)
                ->connect();
        } catch (NoConnectionException $exception) {
            $result['message'] = __('EDI connection - Error: %1', $exception->getMessage());
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }
}
