<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-12-02
 ******************************************************************************/

namespace Fastmag\Sync\Console;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Process\Manager\RemoteSync;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SyncRemoteCommand
 *
 * Command class for remote sync process
 */
class SyncRemoteCommand extends Command
{
    /** @var Logger $logger */
    protected $logger;

    /** @var RemoteSync $remoteSync */
    protected $remoteSync;

    /** @var State $state */
    protected $state;

    /**
     * SyncRemoteCommand constructor
     *
     * @param Logger      $logger
     * @param RemoteSync  $remoteSync
     * @param State       $state
     * @param string|null $name
     */
    public function __construct(
        Logger $logger,
        RemoteSync $remoteSync,
        State $state,
        string $name = 'fastmag-sync:remote'
    ) {
        $this->logger = $logger;
        $this->remoteSync = $remoteSync;
        $this->state = $state;

        parent::__construct($name);
    }

    /**
     * @inheritDoc
     *
     * @return void
     */
    protected function configure()
    {
        $this->setDescription('Sync remote Fastmag jobs queue in Magento local jobs queues');

        parent::configure();
    }

    /**
     * @inheritDoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $result = 0;

        try {
            $this->state->setAreaCode(Area::AREA_ADMINHTML);
        } catch (LocalizedException $exception) {
            // Do nothing
        }

        $this->logger->debug('Beginning remote synchronization');

        // when called as a daemon, we need to set a sleeping time to avoid API calls multiplication
        sleep(30);

        try {
            $this->remoteSync->run();
        } catch (Exception $exception) {
            $output->writeln($exception->getMessage() . "\n" . $exception->getTraceAsString());
            $result = 1;
        }

        return $result;
    }
}
