<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-10-28
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\System\Config\Connection;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Edi
 *
 * Config field block displaying EDI connection status
 *
 * @see \Magento\Customer\Block\Adminhtml\System\Config\Validatevat
 *
 * @method string getButtonLabel()
 * @method string getHtmlId()
 * @method string getAjaxUrl()
 */
class Edi extends Field
{
    /** @var string $ediHostField */
    protected $hostField = 'fastmag_sync_connect_edi_host';

    /** @var string $ediPortField */
    protected $portField = 'fastmag_sync_connect_edi_port';

    /** @var string $ediChainField */
    protected $chainField = 'fastmag_sync_connect_edi_chain';

    /** @var string $ediShopField */
    protected $shopField = 'fastmag_sync_connect_edi_shop';

    /** @var string $ediUserField */
    protected $userField = 'fastmag_sync_connect_edi_user';

    /** @var string $ediPasswordField */
    protected $passwordField = 'fastmag_sync_connect_edi_password';

    /** @var string $ediSslField */
    protected $sslField = 'fastmag_sync_connect_edi_ssl';

    /** @var string $buttonLabel */
    protected $buttonLabel = 'Test connection';

    /** @var string $ediResultField */
    protected $resultField = 'test_connection_edi_result';

    /** @var string $resultFieldPrefixId */
    protected $resultFieldPrefixId = 'result_fastmag_sync_connect_edi_connection_';

    /**
     * Get EDI Host Field Name
     *
     * @return string
     */
    public function getHostField()
    {
        return $this->hostField;
    }

    /**
     * Get EDI Port Number Field
     *
     * @return string
     */
    public function getPortField()
    {
        return $this->portField;
    }

    /**
     * Get EDI Chain Field
     *
     * @return string
     */
    public function getChainField()
    {
        return $this->chainField;
    }

    /**
     * Get EDI Shop Field
     *
     * @return string
     */
    public function getShopField()
    {
        return $this->shopField;
    }

    /**
     * Get EDI User Number Field
     *
     * @return string
     */
    public function getUserField()
    {
        return $this->userField;
    }

    /**
     * Get EDI Password Field
     *
     * @return string
     */
    public function getPasswordField()
    {
        return $this->passwordField;
    }

    /**
     * Get EDI SSL Field
     *
     * @return string
     */
    public function getSslField()
    {
        return $this->sslField;
    }

    /**
     * Get ID for field displaying the result of Fastmag EDI connection
     *
     * @return string
     */
    public function getResultField()
    {
        return $this->resultField;
    }

    /**
     * Get ID for field displaying the result of Fastmag EDI connection
     *
     * @param string $suffix
     *
     * @return string
     */
    public function getResultFieldId($suffix)
    {
        return $this->resultFieldPrefixId . $suffix;
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();

        $this->setTemplate('system/config/connection/edi.phtml');

        return $this;
    }

    /**
     * Unset some non-related element parameters
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();

        return parent::render($element);
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $buttonLabel = !empty($originalData['button_label']) ? $originalData['button_label'] : $this->buttonLabel;
        $this->addData(
            [
                'button_label' => __($buttonLabel),
                'html_id'      => $element->getHtmlId(),
                'ajax_url'     => $this->_urlBuilder->getUrl('fastmagsync/system_config_connection/edi'),
            ]
        );

        return $this->_toHtml();
    }
}
