<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-07
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Rule;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class TransactionTypes
 *
 * Source for transaction types
 */
class TransactionTypes implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_NONE,
                'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_NONE
            ],
            [
                'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE,
                'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE
            ],
            [
                'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_ORDER,
                'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_ORDER
            ],
            [
                'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION,
                'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION
            ],
            [
                'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_CANCELLATION,
                'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_CANCELLATION
            ],
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_NONE
                => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_NONE,
            OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE
                => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE,
            OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_ORDER
                => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_ORDER,
            OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION
                => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION,
            OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_CANCELLATION
                => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_CANCELLATION,
        ];
    }
}
