<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\PaymentId\Extractor;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Extractor\Order\PaymentId\Extractor;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Module\Manager as ModuleManager;
use Magento\Sales\Api\Data\OrderInterface as OrderModel;

/**
 * Class WorldpayCc
 *
 * Class extracting the order payment ID for Worldpay CC payment method
 */
class WorldpayCc extends Extractor
{
    protected Config $config;
    protected ModuleManager $moduleManager;

    /** @var \Sapient\Worldpay\Model\WorldpaymentFactory $worldpayPaymentFactory */
    protected $worldpayPaymentFactory;

    /**
     * WorldpayCc constructor
     *
     * @param OrderModel    $order
     * @param Config        $config
     * @param ModuleManager $moduleManager
     */
    public function __construct(
        OrderModel $order,
        Config $config,
        ModuleManager $moduleManager
    ) {
        parent::__construct($order);

        $this->config = $config;
        $this->moduleManager = $moduleManager;
    }

    /**
     * @inheritDoc
     */
    public function extract(): string
    {
        $result = '';

        $payment = $this->order->getPayment();

        if ($payment !== null) {
            if ($payment->getMethod() === 'worldpay_cc'
                && $this->moduleManager->isEnabled('Sapient_Worldpay')
                && $this->config->isSetFlag(Config::XML_PATH_ORDER_EXPORT_USE_WORLDPAY_ID)
            ) {
                // TODO : find a cleaner way
                $objectManager = ObjectManager::getInstance();
                $this->worldpayPaymentFactory = $objectManager->create('Sapient\Worldpay\Model\WorldpaymentFactory');

                $worldpayPayment = $this->worldpayPaymentFactory->create();
                $worldpayPayment->loadByPaymentId($this->order->getIncrementId());

                $result = $worldpayPayment->getWorldpayOrderId();
            } else {
                $result = parent::extract();
            }
        }

        return $result;
    }
}
