<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-09-04
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel\Order\Grid;

use Fastmag\Sync\Model\ResourceModel\Order\Collection as OrderCollection;
use Magento\Framework\Api\Search\AggregationInterface;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\View\Element\UiComponent\DataProvider\Document;
use Psr\Log\LoggerInterface;

/**
 * Class Collection
 *
 * Synced order model collection for admin grid
 */
class Collection extends OrderCollection implements SearchResultInterface
{
    /** @var AggregationInterface $aggregations */
    protected $aggregations;

    /**
     * Collection constructor
     *
     * @param EntityFactoryInterface       $entityFactory
     * @param LoggerInterface              $logger
     * @param FetchStrategyInterface       $fetchStrategy
     * @param ManagerInterface             $eventManager
     * @param string                       $mainTable
     * @param string                       $eventPrefix
     * @param string                       $eventObject
     * @param string                       $resourceModel
     * @param string                       $model
     * @param AdapterInterface|string|null $connection
     * @param AbstractDb|null              $resource
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface $eventManager,
        $mainTable,
        $eventPrefix,
        $eventObject,
        $resourceModel,
        $model = Document::class,
        $connection = null,
        AbstractDb $resource = null
    ) {
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $connection,
            $resource
        );

        $this->_eventPrefix = $eventPrefix;
        $this->_eventObject = $eventObject;
        $this->_init($model, $resourceModel);
        $this->setMainTable($mainTable);
    }

    /**
     * @inheritDoc
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @inheritDoc
     */
    public function setAggregations($aggregations)
    {
        $this->aggregations = $aggregations;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getSearchCriteria()
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function setSearchCriteria(SearchCriteriaInterface $searchCriteria = null)
    {
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTotalCount()
    {
        return $this->getSize();
    }

    /**
     * @inheritDoc
     */
    public function setTotalCount($totalCount)
    {
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setItems(array $items = null)
    {
        return $this;
    }

    /**
     * Add increment_id of the order linked, if the job is on an order
     *
     * @inheritDoc
     */
    protected function _initSelect()
    {
        $this->addFilterToMap('status', 'main_table.status');

        parent::_initSelect();

        $this->getSelect()
            ->columns('so.increment_id')
            ->joinLeft(
                ['so' => $this->getTable('sales_order')],
                'so.entity_id = main_table.order_id',
                []
            );
    }
}
