<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-05-31
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface LogInterface
 */
interface LogInterface
{
    /** @var int */
    public const LOG_ID = 'log_id';

    /** @var string */
    public const MESSAGE = 'message';

    /** @var string */
    public const LEVEL = 'level';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get message
     *
     * @return string|null
     */
    public function getMessage();

    /**
     * Get level
     *
     * @return string|null
     */
    public function getLevel();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Set ID
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setId($logId);

    /**
     * Set message
     *
     * @param string $message
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setMessage($message);

    /**
     * Set level
     *
     * @param string $level
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setLevel($level);
}
