<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-07-27
 ******************************************************************************/

namespace Fastmag\Sync\FastmagSetup;

/**
 * Class Uninstaller
 *
 * Class handling job queue and triggers deletion on Fastmag
 */
class Uninstaller
{
    /**
     * Get uninstallation queries
     *
     * @return array
     */
    public function getUninstallQueries()
    {
        $sql = ['triggers' => [], 'tables' => []];

        $sql['tables'] = ['DROP TABLE IF EXISTS fmsync_job_queue;'];

        $sql['triggers'] = [
            'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_client_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_client_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_complementsr_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_complementsr_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_coupons_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_coupons_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_offrescommerciales_magasins_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_offrescommerciales_magasins_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_offrescommerciales_produits_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_offrescommerciales_produits_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_offrescommerciales_produits_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremise_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremise_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremise_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremisetc_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremisetc_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_prixremisetc_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_negoce_entete_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_negoce_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_negoce_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produitsfiches_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produitslangues_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_insert;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_update;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_delete;',
            'DROP TRIGGER IF EXISTS trigger_fmsync_vente_update;',
        ];

        return $sql;
    }
}
