<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-05
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Order;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface;
use Fastmag\Sync\Model\Config\Source\Rule\TransactionTypes as RuleTransactionTypes;

/**
 * Class TransactionTypes
 *
 * Source for transaction types
 */
class TransactionTypes extends RuleTransactionTypes
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return array_merge(
            parent::toOptionArray(),
            [
                [
                    'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE,
                    'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE
                ],
                [
                    'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE_CANCELLATION,
                    'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE_CANCELLATION
                ],
                [
                    'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION_CANCELLATION,
                    'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION_CANCELLATION
                ],
                [
                    'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER,
                    'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER
                ],
                [
                    'value' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER_CANCELLATION,
                    'label' => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER_CANCELLATION
                ],
            ]
        );
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return array_merge(
            parent::toOptionArray(),
            [
                OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE
                    => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE,
                OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE_CANCELLATION
                    => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_SALE_CANCELLATION,
                OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION_CANCELLATION
                    => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_RESERVATION_CANCELLATION,
                OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER
                    => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER,
                OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER_CANCELLATION
                    => OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER_CANCELLATION,
            ]
        );
    }
}
