<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-02
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Inventory;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\InventoryApi\Api\Data\SourceInterface as SourceModel;
use Magento\InventoryApi\Api\SourceRepositoryInterface as SourceRepository;

/**
 * Class Source
 *
 * Give inventory source as options for a config field, as the Inventory module does not provide it.
 *
 * @see \Magento\Catalog\Model\Product\AttributeSet\Options
 */
class Source implements OptionSourceInterface
{
    /** @var SourceRepository */
    protected $sourceRepository;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /** @var array $options */
    protected $options;

    /**
     * Source constructor
     *
     * @param SourceRepository      $sourceRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(SourceRepository $sourceRepository, SearchCriteriaBuilder $searchCriteriaBuilder)
    {
        $this->sourceRepository = $sourceRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        if ($this->options === null) {
            $searchCriteria = $this->searchCriteriaBuilder
                ->addFilter(SourceModel::ENABLED, true)
                ->create();

            $sourcesList = $this->sourceRepository->getList($searchCriteria);

            foreach ($sourcesList->getItems() as $source) {
                $this->options[] = [
                    'value' => $source->getSourceCode(),
                    'label' => $source->getName(),
                ];
            }
        }

        return $this->options;
    }
}
