<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\PaymentId;

use Magento\Framework\ObjectManagerInterface as ObjectManager;

/**
 * Class ExtractorFactory
 *
 * Factory class for order payment ID extractor classes
 */
class ExtractorFactory
{
    protected ObjectManager $objectManager;

    protected array $extractors = [];

    /**
     * ExtractorFactory constructor
     *
     * @param ObjectManager $objectManager
     * @param string[]      $extractors
     */
    public function __construct(ObjectManager $objectManager, array $extractors = [])
    {
        $this->objectManager = $objectManager;
        $this->extractors = $extractors;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param string $method
     * @param array  $data
     *
     * @return Extractor
     */
    public function create($method, array $data = []): Extractor
    {
        if (array_key_exists($method, $this->extractors)) {
            $instanceName = $this->extractors[$method];
        } else {
            $instanceName = $this->extractors['standard'];
        }

        return $this->objectManager->create($instanceName, $data);
    }
}
