<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-09-04
 ******************************************************************************/

namespace Fastmag\Sync\Observer\Jobqueue\ToFastmag;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory as JobFactory;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Sales\Model\Order;

/**
 * Class AddOrderJob
 *
 * Observer adding a tofastmag_integration_order job to the "To Fastmag" job queue
 */
class AddOrderJob implements ObserverInterface
{
    /** @var JobFactory */
    protected JobFactory $jobFactory;

    /** @var JobRepository */
    protected JobRepository $jobRepository;

    /** @var Logger */
    protected Logger $logger;

    /**
     * AddOrderJob constructor
     *
     * @param JobFactory    $jobFactory
     * @param JobRepository $jobRepository
     * @param Logger        $logger
     */
    public function __construct(JobFactory $jobFactory, JobRepository $jobRepository, Logger $logger)
    {
        $this->jobFactory = $jobFactory;
        $this->jobRepository = $jobRepository;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        /** @var Order $order */
        $order = $observer->getOrder();

        if ($order->getEntityId()
            && $order->getPayment()
            && !in_array($order->getState(), ['', Order::STATE_CLOSED, Order::STATE_CANCELED], true)
        ) {
            try {
                $key = $order->getEntityId() . '_' . $order->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order');

                $this->jobRepository->save($job);
            } catch (CouldNotSaveException $exception) {
                $this->logger->error($exception->getMessage());
            }
        }
    }
}
