<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-21
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration\Customer\Address;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration\Address as AbstractAddress;

/**
 * Class Shipping
 *
 * Integration class used for inserting or updating customer shipping addresses from Magento to Fastmag
 */
class Shipping extends AbstractAddress
{
    /** @inheritDoc */
    protected $code = 'tofastmag_integration_customer_address_shipping';

    /** @var string $hydrationWorker */
    protected $hydrationWorker = 'tofastmag_hydration_customer_address_shipping';

    /**
     * @inheritDoc
     */
    public function isEnabled()
    {
        return $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_EXPORT_ENABLE);
    }

    /**
     * @inheritDoc
     */
    protected function getCustomerEntity($job)
    {
        return $job->getEntity();
    }
}
