<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-05-10
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Preconfig;

use Exception;
use Fastmag\Sync\Controller\Adminhtml\Preconfig;
use Fastmag\Sync\Helper\Email;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Index
 *
 * Preconfig form action
 */
class Index extends Preconfig implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected PageFactory $resultPageFactory;

    /**
     * Index constructor
     *
     * @param Context     $context
     * @param Config      $config
     * @param Logger      $logger
     * @param Email       $emailHelper
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context     $context,
        Config      $config,
        Logger      $logger,
        Email       $emailHelper,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context, $config, $logger, $emailHelper);

        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage(Page $resultPage): Page
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_preconfig')
            ->addBreadcrumb(__('Preconfig'), __('Preconfig'));

        return $resultPage;
    }

    /**
     * Display admin listing of the customers synced
     *
     * @return ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Preconfig'));

        $this->sendAccessEmail();

        return $resultPage;
    }

    /**
     * Send access email for monitoring
     *
     * @return void
     */
    protected function sendAccessEmail()
    {
        /** @var Http $request */
        $request = $this->getRequest();

        $httpHost = $request->getServer('HTTP_HOST');

        try {
            $this->emailHelper->setTemplateId('fastmag_sync_preconfig_access')
                ->setTemplateVariables([
                    'date'        => date('Y-m-d H:i:s'),
                    'user_ip'     => $request->getServer('REMOTE_ADDR'),
                    'server_ip'   => $request->getServer('SERVER_ADDR'),
                    'external_ip' => gethostbyname($httpHost),
                    'store_url'   => $httpHost
                ])
                ->sendEmail();
        } catch (Exception $exception) {
            $this->logger->warning(
                __(
                    'Error while sending preconfig access email: %1 - Trace: %2',
                    $exception->getMessage(),
                    $exception->getTraceAsString()
                )->render()
            );
        }
    }
}
