<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule;

use Fastmag\Sync\Api\Rule\TaxclassfamilyRepositoryInterface as RuleRepository;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Request\DataPersistorInterface;

/**
 * Class Taxclassfamily
 */
abstract class Taxclassfamily extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::taxclass_family';

    /** @var DataPersistorInterface $dataPersistor */
    protected $dataPersistor;

    /** @var RuleRepository $ruleRepository */
    protected $ruleRepository;

    /**
     * Taxclassfamily constructor
     *
     * @param Context                $context
     * @param DataPersistorInterface $dataPersistor
     * @param RuleRepository         $ruleRepository
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        RuleRepository $ruleRepository
    ) {
        parent::__construct($context);

        $this->dataPersistor = $dataPersistor;
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_rule_taxclassfamily')
            ->addBreadcrumb(__('Rules'), __('Rules'))
            ->addBreadcrumb(__('Tax Class/Family'), __('Tax Class/Family'));

        return $resultPage;
    }
}
