<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-11
 ******************************************************************************/

namespace Fastmag\Sync\Model\Api\Connection;

use Fastmag\Sync\Api\Data\Connection\StatusResponseInterface;
use Magento\Framework\DataObject;

/**
 * Class StatusResponse
 *
 * Format checkStatus response
 */
class StatusResponse extends DataObject implements StatusResponseInterface
{
    /**
     * @inheritDoc
     */
    public function getApi()
    {
        return $this->_getData(self::API);
    }

    /**
     * @inheritDoc
     */
    public function getEdi()
    {
        return $this->_getData(self::EDI);
    }

    /**
     * @inheritDoc
     */
    public function getMysql()
    {
        return $this->_getData(self::MYSQL);
    }

    /**
     * @inheritDoc
     */
    public function setApi($api)
    {
        return $this->setData(self::API, $api);
    }

    /**
     * @inheritDoc
     */
    public function setEdi($edi)
    {
        return $this->setData(self::EDI, $edi);
    }

    /**
     * @inheritDoc
     */
    public function setMysql($mysql)
    {
        return $this->setData(self::MYSQL, $mysql);
    }
}