<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-15
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Exception;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\Order as OrderModel;

/**
 * Class OrderCancellation
 *
 * Plugin on Order model to add an order cancellation job in ToFastmag job queue
 */
class OrderCancellation extends ToFastmag
{
    /**
     * @see Order::cancel()
     *
     * @param OrderModel     $subject
     * @param OrderInterface $result
     *
     * @return OrderInterface
     *
     * @throws Exception
     */
    public function afterCancel(OrderModel $subject, $result)
    {
        if ($result->isCanceled() && $this->config->isSetFlag(Config::XML_PATH_ORDER_EXPORT_ENABLE)) {
            try {
                $key = $subject->getEntityId() . '_' . $subject->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order_cancellation');

                $this->jobRepository->save($job);
            } catch (Exception $exception) {
                $this->logger->error($exception->getMessage());
            }
        }

        return $result;
    }
}
