<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-12-02
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use DateTime;
use DateTimeZone;
use Exception;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\Pdo\Mysql;

/**
 * Trait Clean
 *
 * Trait for all cleaning workers
 */
trait Clean
{
    /** @var ResourceConnection $resourceConnection */
    protected $resourceConnection;

    /**
     * Get worker code
     *
     * @return string
     */
    abstract public function getCode();

    /**
     * Get manager last execution date
     *
     * Returns date as string if there is an Exception threw by DateTime constructor
     *
     * @return DateTime|string
     */
    public function getLastExecutionDate()
    {
        $select = $this->resourceConnection->getConnection()
            ->select()
            ->from('fastmag_sync_job_last_execution', 'last_executed_at')
            ->where('job_code = \'' . $this->getCode() . '\'');

        $value = $this->resourceConnection->getConnection()->fetchOne($select);

        try {
            if ($value === false) {
                $result = new DateTime('1970-01-01');
            } else {
                $result = new DateTime($value);
            }
        } catch (Exception $exception) {
            $result = $value;
        }

        return $result;
    }

    /**
     * Set manager last execution date
     *
     * @param Datetime|string $date
     *
     * @return bool
     */
    public function setLastExecutionDate($date = null)
    {
        if ($date === null) {
            try {
                $date = new DateTime();
            } catch (Exception $exception) {
                $date = date(Mysql::DATETIME_FORMAT);
            }
        }

        if (get_class($date) === 'DateTime') {
            $date = $date->format(Mysql::DATETIME_FORMAT);
        }

        $data = [
            'job_code'         => $this->getCode(),
            'last_executed_at' => $date
        ];

        $affectedRows = $this->resourceConnection->getConnection()
            ->insertOnDuplicate('fastmag_sync_job_last_execution', $data, ['last_executed_at']);

        return ($affectedRows === 1);
    }

    /**
     * Returns string if there is an exception threw by DateTime constructor
     *
     * @param string $date
     *
     * @return DateTime|string
     */
    protected function getUtcDateTimeFromFastmag($date)
    {
        try {
            $dateTime = new DateTime($date, new DateTimeZone('Europe/Paris'));
            $dateTime->setTimezone(new DateTimeZone('UTC'));
        } catch (Exception $exception) {
            $dateTime = $date;
        }

        return $dateTime;
    }
}
