<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-09-04
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Customer;

use Magento\Framework\Phrase;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class IsDeleted
 *
 * Column renderer for customer and address deletion status
 */
class IsDeleted extends Column
{
    /**
     * Prepare data source.
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return Phrase
     */
    protected function prepareItem(array $item)
    {
        $fieldName = $this->getData('name');

        if (isset($item[$fieldName]) && $item[$fieldName] === '1') {
            $content = __('Yes');
        } else {
            $content = __('No');
        }

        return $content;
    }
}
