<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-05-31
 ******************************************************************************/

namespace Fastmag\Sync\Api;

use Fastmag\Sync\Api\Data\LogInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface LogRepositoryInterface
 */
interface LogRepositoryInterface
{
    /**
     * Save log.
     *
     * @param \Fastmag\Sync\Api\Data\LogInterface $log
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(LogInterface $log);

    /**
     * Retrieve log.
     *
     * @param int $entityId
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($entityId);

    /**
     * Retrieve logs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\LogSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete log.
     *
     * @param \Fastmag\Sync\Api\Data\LogInterface $log
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(LogInterface $log);

    /**
     * Delete log by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);
}
