<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-05-16
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Preconfig;

use Exception;
use Fastmag\Sync\Controller\Adminhtml\Preconfig;
use Fastmag\Sync\Helper\Email;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Constants;
use Fastmag\Sync\Model\System\Connection\Sql\EdiSql;
use Fastmag\Sync\Model\System\Preconfig\File;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Request\Http;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Math\Random;
use Magento\Framework\Module\ResourceInterface as ModuleResource;

/**
 * Class Generate
 *
 * Preconfig generate SQL action
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Generate extends Preconfig
{
    /** @var ModuleResource $moduleResource */
    protected ModuleResource $moduleResource;

    /** @var Random $randomGenerator */
    protected Random $randomGenerator;

    /** @var ResourceConnection $resourceConnection */
    protected ResourceConnection $resourceConnection;

    /** @var EdiSql $ediSql */
    protected EdiSql $ediSql;

    /** @var JsonFactory $resultJsonFactory */
    protected JsonFactory $resultJsonFactory;

    /** @var File $file */
    protected File $file;

    /** @var string $user */
    protected $user;

    /** @var string $pass */
    protected $pass;

    /** @var string $toFile */
    protected $toFile;

    /**
     * Generate constructor
     *
     * @param Context            $context
     * @param Config             $config
     * @param Logger             $logger
     * @param Email              $emailHelper
     * @param ModuleResource     $moduleResource
     * @param Random             $randomGenerator
     * @param ResourceConnection $resourceConnection
     * @param EdiSql             $ediSql
     * @param File               $file
     * @param JsonFactory        $resultJsonFactory
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        Context            $context,
        Config             $config,
        Logger             $logger,
        Email              $emailHelper,
        ModuleResource     $moduleResource,
        Random             $randomGenerator,
        ResourceConnection $resourceConnection,
        EdiSql             $ediSql,
        File               $file,
        JsonFactory        $resultJsonFactory
    ) {
        parent::__construct($context, $config, $logger, $emailHelper);

        $this->moduleResource = $moduleResource;
        $this->randomGenerator = $randomGenerator;
        $this->resourceConnection = $resourceConnection;
        $this->ediSql = $ediSql;
        $this->file = $file;
        $this->resultJsonFactory = $resultJsonFactory;
    }

    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     */
    public function execute()
    {
        /** @var Http $request */
        $request = $this->getRequest();
        $this->user = $request->getParam('user');
        $this->pass = str_shuffle($this->randomGenerator->getRandomString(12) . '@#/~');

        $version = $this->moduleResource->getDbVersion('Fastmag_Sync');

        $proxyIp = '10.0.1.209';
        $proxyUser = $this->config->getValue(Config::XML_PATH_CONNECT_PROXY_USER);
        $proxyPass = $this->config->getValue(Config::XML_PATH_CONNECT_PROXY_PASSWORD);

        $dataSource = $this->ediSql->getDataSource();

        $result = '/*<br />'
            .'Version module FastmagSync M2 HomeMade : ' . $version . '<br />';

        $httpHost = $request->getServer('HTTP_HOST');
        $externalIp = gethostbyname($httpHost);

        $result .= 'Connexion Ace Preconfig' . '<br />';
        $result .= '--------------------------------------------------' . '<br />';
        $result .= 'Date : ' . date('Y-m-d H:i:s') . '<br />';
        $result .= 'IP utilisateur : ' . $request->getServer('REMOTE_ADDR') . '<br />';
        $result .= 'IP serveur : ' . $request->getServer('SERVER_ADDR') . '<br />';
        $result .= 'IP externe : ' . $externalIp . '<br />';
        $result .= 'URL site : ' . $httpHost . '<br />';
        $result .= '*/<br /><br />';

        $result .= '<br />';
        $result .= '<h3>/****** <strong>[Si ancien compte]</strong> Suppression anciens droits ******/</h3>';
        $result .= 'REVOKE ALL PRIVILEGES, GRANT OPTION FROM \'' . $this->user . '\'@\'%\';' . '<br />';
        $result .= 'REVOKE ALL PRIVILEGES, GRANT OPTION FROM \'' . $this->user . '\'@\'' . $proxyIp . '\';' . '<br />';

        $result .= '<br />';
        $result .= '<h3>/****** <strong>[Si anciennes tables]</strong> Drop ******/</h3>';
        $result .= 'DROP TABLE IF EXISTS fmsync_job_queue;' . '<br />';
        $result .= 'DROP TABLE IF EXISTS fmsb_mage_job_queue;' . '<br />';
        $result .= 'DROP TABLE IF EXISTS presta_fm_job_queue;' . '<br />';
        $result .= 'DROP TABLE IF EXISTS presta_job_queue;' . '<br />';
        $result .= 'DROP TABLE IF EXISTS presta_job_queue_schedule;' . '<br />';
        $result .= 'DROP TABLE IF EXISTS presta_job_queue_website;' . '<br />';

        $result .= '<br />';
        $result .= '<h3>/********************* <strong>Nouveaux Droits</strong> *********************/</h3>';
        $result .= '<h4>/****** Creation user ******/' . '</h4>';
        $result .= 'CREATE USER ' . $this->user . '@' . $proxyIp . ' IDENTIFIED BY \'' . $this->pass . '\';' . '<br />';

        $result .= '<br />';
        $result .= '<h3>/****** Privileges Proxy tables module ******/</h3>';
        $result .= 'GRANT ALL PRIVILEGES ON ' . $dataSource . '.fmsync_job_queue TO \''
            . $this->user . '\'@\'' . $proxyIp . '\';' . '<br />';

        $result .= '<br />';
        $result .= '<h3>/****** Privileges Proxy SELECT ******/</h3>';
        $result .= 'GRANT SELECT ON ' . $dataSource . '.* TO \'' . $this->user . '\'@\'' . $proxyIp . '\';' . '<br />';

        // Home-Made Proxy
        $result .= '<br />';
        $result .= '<h3>/****** Privileges Proxy Monitoring ******/</h3>';
        $result .= '<h4>/* Proxy Monitor */</h4>';
        $result .= 'GRANT USAGE ON ' . $dataSource . '.* TO \'' . $proxyUser . '\'@\'' . $proxyIp
            . '\' IDENTIFIED BY \'' . $proxyPass . '\';' . '<br />';
        $result .= '<br / >';
        $result .= 'FLUSH PRIVILEGES;' . '<br />';

        // Utilies products creation
        $result .= '<br />';
        $result .= '<h3>/****** Creation produits module ******/</h3>';
        $result .= 'USE ' . $dataSource . ';' . '<br /><br />';

        $utilitiesProducts = $this->getUtilitariansProducts();
        foreach ($utilitiesProducts as $sku => $name) {
            $result .= 'INSERT INTO produitsfiches '
                . '(BarCode, Designation, Designation2, Modele, Matiere, Marque, Rayon, Famille, SsFamille, Saison, '
                . 'Descriptif, PrixAchat, PrixVente, VisibleWeb, EnPromotion, EnNouveaute, Actif, '
                . 'ConditionnementAchat, ConditionnementVente, ConditionnementReassort, Fournisseur, Theme, Poids, '
                . 'Volume, Nomenclature, Emplacement, WebLink, GL_SsFamille, GL_NGP, GL_TVA, GL_Famille, GL_Marque, '
                . 'TauxCommission, RemiseMax, DerniereModifPhoto, OrdreTriVshop, StatAffichage, StatConsultation, '
                . 'StatSelection, StatCommande, CEPL_Modif, LastGenerationImage, LibelleCondAchat, DroitMinimum, '
                . 'DateCreation, DateModif, Utilisateur, Lavage, Chlore, Repassage, Pressing, Sechage, AquaNettoyage, '
                . 'VisibleWebB2B, ConditionnementVenteNegoce, OrigineFab, grilleTailles, Web_SeuilMini, Automate, '
                . 'EBiz_MustHave, EBiz_Limited, EBiz_Best, SuiviFabrication, SoumisAAutorisation, EbizOperationDebut, '
                . 'EbizOperationFin, FideliteNiveau, Serialisable, Unite, Contenance, WebLink_Photo) '
                . 'VALUES '
                . '(\'' . $sku . '\', \'' . $name . '\', \'\', \'\', \'\', \'\', \'\', \'~UTILSWEB\', '
                . '\'\', \'\', NULL, 0.00, 0.00, 0, 0, 0, 1, 1.000, 1.000, 1.000, \'\', \'\', 0.0000, 0.0000, NULL, '
                . '\'\', NULL, \'\', 0, \'\', \'\', \'\', 100.00, 100.00, NULL, 100, 0, 0, 0, 0, NULL, NULL, \'\', 0, '
                . 'NOW(), NOW(), \'HOMEMADE\', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1.000, NULL, 0, \'\', \'\', 0, '
                . '0, 0, \'\', 0, NULL, NULL, 0, 0, \'\', 0.0000, \'\') '
                . 'ON DUPLICATE KEY UPDATE Designation = \'' . $name . '\',  DateModif = NOW();<br />';

            $result .= 'INSERT INTO produits '
                . '(BarCode, Couleur, Taille, GenCod, PrixAchat, PrixVente, RefFournisseur, ProduitActif, InfosComp, '
                . 'NoEbiz, EcoTaxe_Code, EcoTaxe_HT, EcoTaxe_TTC, coeffPA0, PoidsTC, ContenanceTC) '
                . 'VALUES '
                . '(\'' . $sku . '\', \'\', \'\', \'\', 0.00, 0.00, \'\', 1, NULL, 0, NULL, 0.0000, 0.0000, 0.00000, '
                . '0.0000, 0.0000) '
                . 'ON DUPLICATE KEY UPDATE Couleur = \'\';<br /><br />';
        }

        $this->sendQueriesEmail();

        $this->file->write($this->toFile);

        if (!$this->file->exists()) {
            $result .= '<br /><br />############################################################################<br />';
            $result .= nl2br($this->toFile);
            $result .= '<br />############################################################################<br /><br />';
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData([$result]);
    }

    /**
     * List utilitarians products / reference used by module FastmagSync
     *
     * @return array
     */
    protected function getUtilitariansProducts(): array
    {
        return [
            Constants::PRODUCT_FP_SKU     => 'FRAIS DE PORT INTERNET',
            Constants::PRODUCT_REGVAT_SKU => 'REGUL TVA',
        ];
    }

    /**
     * Send queries email for monitoring
     *
     * @return void
     */
    protected function sendQueriesEmail(): void
    {
        /** @var Http $request */
        $request = $this->getRequest();

        $httpHost = $request->getServer('HTTP_HOST');

        $connection = $this->resourceConnection->getConnection();
        $hashPass = $connection->fetchOne('SELECT PASSWORD(\'' . $this->pass . '\') AS Pwd');

        $dataSource = $this->ediSql->getDataSource();

        try {
            $this->emailHelper->setTemplateId('fastmag_sync_preconfig_queries')
                ->setTemplateVariables([
                    'date'          => date('Y-m-d H:i:s'),
                    'user_ip'       => $request->getServer('REMOTE_ADDR'),
                    'server_ip'     => $request->getServer('SERVER_ADDR'),
                    'external_ip'   => gethostbyname($httpHost),
                    'store_url'     => $httpHost,
                    'user_password' => $this->pass,
                    'user_name'     => $this->user,
                    'hash_pass'     => $hashPass,
                    'data_source'   => $dataSource,
                    'fastmag_chain' => ucfirst(strtolower($this->ediSql->getChain()))
                ])
                ->sendEmail();
        } catch (Exception $exception) {
            $this->logger->warning(
                __(
                    'Error while sending preconfig queries email: %1 - Trace: %2',
                    $exception->getMessage(),
                    $exception->getTraceAsString()
                )->render()
            );
        }
    }
}
