<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-05-16
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\FastmagSetup\Installer;
use Fastmag\Sync\FastmagSetup\Uninstaller;
use Fastmag\Sync\Model\System\Connection\Sql\DirectSql;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Queue
 *
 * Controller allowing the reinstallaton of the queue on Fastmag DB
 */
class Queue extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::queue';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var DirectSql $connection */
    protected $connection;

    /** @var Installer $installer */
    protected $installer;

    /** @var Uninstaller $uninstaller */
    protected $uninstaller;

    /**
     * Queue constructor
     *
     * @param Context     $context
     * @param JsonFactory $resultJsonFactory
     * @param DirectSql   $connection
     * @param Installer   $installer
     * @param Uninstaller $uninstaller
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        DirectSql $connection,
        Installer $installer,
        Uninstaller $uninstaller
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->connection = $connection;
        $this->installer = $installer;
        $this->uninstaller = $uninstaller;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $this->reinstallQueue();

            $result = [
                'queue_reinstalled' => 1,
                'message'           => __('The queue have been reinstalled.')
            ];
        } catch (NoConnectionException $exception) {
            $result = [
                'queue_reinstalled' => 0,
                'message'           => __('Unable to reinstall queue. Error: %1', $exception->getMessage())
            ];
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }

    /**
     * Reinstall queue on Fastmag using SQL proxy
     *
     * @throws NoConnectionException
     */
    public function reinstallQueue()
    {
        $sql = $this->uninstaller->getUninstallQueries();

        $this->connection->connect();

        foreach ($sql as $query) {
            $this->connection->post($query);
        }

        $sql = $this->installer->getInstallQueries();

        foreach ($sql as $query) {
            $this->connection->multiPost($query);
        }
    }
}
