<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-05-31
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Customer;

use Fastmag\Sync\Model\Constants;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class GroupField
 *
 * Source for customers group field
 */
class GroupField implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => Constants::VALUE_GENERAL, 'label' => __('Affect to the group "General"')],
            [
                'value' => Constants::VALUE_DISCOUNT,
                'label' => __('Affect to automatically created groups according to "Remise" field')
            ],
            [
                'value' => Constants::VALUE_GROUPING,
                'label' => __('Affect to automatically created groups according to "Regroupement" field')
            ],
            [
                'value' => Constants::VALUE_BOTH,
                'label' =>
                    __('Affect to automatically created groups according to both fields ("Regroupement", then "Remise")')
            ]
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            Constants::VALUE_GENERAL  => __('Affect to the group "General"'),
            Constants::VALUE_DISCOUNT => __('Affect to automatically created groups according to "Remise" field'),
            Constants::VALUE_GROUPING => __('Affect to automatically created groups according to "Regroupement" field'),
            Constants::VALUE_BOTH     =>
                __('Affect to automatically created groups according to both fields ("Regroupement", then "Remise")'),
        ];
    }
}
