<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\Items\Extractor;

use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Model\Constants;
use Fastmag\Sync\Model\Extractor\Order\Items\Extractor;
use Magento\Bundle\Model\Product\Type as Bundle;
use Magento\Catalog\Api\ProductRepositoryInterface as ProductRepository;
use Magento\Catalog\Model\Product\Type;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Module\Manager as ModuleManager;
use Magento\Sales\Api\Data\OrderInterface as OrderModel;

/**
 * Class ExtendedBundle
 *
 * Class extracting order items to sync with Fastmag, and checking
 */
class ExtendedBundle extends Extractor
{
    protected ModuleManager $moduleManager;
    protected ProductRepository $productRepository;

    /**
     * ExtendedBundle constructor
     *
     * @param OrderModel        $order
     * @param ModuleManager     $moduleManager
     * @param ProductRepository $productRepository
     */
    public function __construct(OrderModel $order, ModuleManager $moduleManager, ProductRepository $productRepository)
    {
        parent::__construct($order);

        $this->moduleManager = $moduleManager;
        $this->productRepository = $productRepository;
    }

    /**
     * @inheritDoc
     *
     * @throws NoSuchEntityException
     * @throws JobException
     */
    public function extract(): array
    {
        $result = [];

        foreach ($this->order->getAllItems() as $item) {
            $children = $item->getChildrenItems();
            $parentItem = $item->getParentItem();

            if ($item->getProductType() === Configurable::TYPE_CODE &&
                $parentItem && $parentItem->getProductType() === Bundle::TYPE_CODE
                && empty($children)
            ) {
                $childProduct = $this->productRepository->get($item->getSku());

                if ($childProduct->getCustomAttribute(Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE) === null) {
                    throw new JobException(__(
                        'Attribute "fastmag_product_id" does not seem to exist for the product, please stop the synchronization and contact HMio to review this error.'
                    ));
                }

                $item->setName($childProduct->getName())
                    ->setFastmagProductId(
                        $childProduct->getCustomAttribute(Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE)
                            ->getValue()
                    );

                $result[] = $item;
            } elseif ($item->getProductType() === Type::TYPE_SIMPLE) {
                $result[] = $item;
            }
        }

        return $result;
    }
}
