<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-03-30
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration\Customer;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration\Address as AbstractAddress;

/**
 * Class Address
 *
 * Integration class used for inserting or updating customers addresses from Magento to Fastmag
 */
class Address extends AbstractAddress
{
    /** @inheritDoc */
    protected $code = 'tofastmag_integration_customer_address';

    /**
     * @inheritDoc
     */
    public function isEnabled()
    {
        return $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_EXPORT_ENABLE);
    }

    /**
     * @inheritDoc
     */
    protected function processJob($job)
    {
        parent::processJob($job);

        $entity = $this->getCustomerEntity($job);
        $billingAddress = $entity->getBillingAddress();

        if ($billingAddress) {
            $this->saveFastmagAlias($billingAddress->getMagentoId(), $billingAddress->getAlias());
        }
    }

    /**
     * @inheritDoc
     */
    protected function getCustomerEntity($job)
    {
        return $job->getEntity();
    }
}
