<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Api;

/**
 * Interface OrderRepositoryInterface
 */
interface OrderRepositoryInterface
{
    /**
     * Save order.
     *
     * @param \Fastmag\Sync\Api\Data\OrderInterface $order
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Fastmag\Sync\Api\Data\OrderInterface $order): \Fastmag\Sync\Api\Data\OrderInterface;

    /**
     * Retrieve synchronization.
     *
     * @param int $syncId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($syncId): \Fastmag\Sync\Api\Data\OrderInterface;

    /**
     * Retrieve last synchonization for the specific order id, excluding some transactions types if necessary.
     *
     * @param int      $orderId
     * @param string[] $excludeTypes
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getLastSyncByOrderId(
        $orderId,
        $excludeTypes = [\Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface::FASTMAG_TRANSACTION_TYPE_TRANSFER]
    );

    /**
     * Retrieve synchronization by Fastmag transaction ID.
     *
     * @param int $transactionId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getLastSyncByTransactionId($transactionId);

    /**
     * Retrieve orders matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\OrderSearchResultsInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Shortcut method to get all lines applying to a specific order.
     *
     * @param int $orderId
     *
     * @return \Fastmag\Sync\Api\Data\OrderSearchResultsInterface
     */
    public function getListByOrderId($orderId);

    /**
     * Delete synchronization.
     *
     * @param \Fastmag\Sync\Api\Data\OrderInterface $order
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Fastmag\Sync\Api\Data\OrderInterface $order): bool;

    /**
     * Delete synchronization by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);
}
