<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-05-26
 ******************************************************************************/

namespace Fastmag\Sync\Cron;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Process\Manager\RemoteSync;

/**
 * Class SyncRemote
 *
 * Cron class responsible for syncing remote queue in local queue
 */
class SyncRemote
{
    /** @var Logger $logger */
    protected $logger;

    /** @var RemoteSync $remoteSync */
    protected $remoteSync;

    /**
     * RemoteQueue constructor
     *
     * @param Logger     $logger
     * @param RemoteSync $remoteSync
     */
    public function __construct(Logger $logger, RemoteSync $remoteSync)
    {
        $this->logger = $logger;
        $this->remoteSync = $remoteSync;
    }

    /**
     * Main method
     *
     * @throws Exception
     */
    public function execute()
    {
        $this->logger->debug('Beginning remote queue synchronization');

        $this->remoteSync->run();
    }
}
