<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-25
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Paymentcode as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Paymentcode
 *
 * Paymentcode rules model
 *
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
class Paymentcode extends AbstractModel implements PaymentcodeInterface
{
    /** @inheritDoc */
    protected $_cacheTag = 'fastmag_sync_rule_paymentcode';

    /** @inheritDoc */
    protected $_eventPrefix = 'fastmag_sync_rule_paymentcode';

    /**
     * Paymentcode constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getPaymentMethod()
    {
        return $this->getData(self::PAYMENT_METHOD);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagCode()
    {
        return $this->getData(self::FASTMAG_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setPaymentMethod($paymentMethod)
    {
        return $this->setData(self::PAYMENT_METHOD, $paymentMethod);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagCode($fastmagCode)
    {
        return $this->setData(self::FASTMAG_CODE, $fastmagCode);
    }
}
