<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-08-01
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity;

use DateTime;
use DateTimeZone;
use Exception;
use IntlDateFormatter;

trait Date
{
    /** @var IntlDateFormatter $dateFormatter */
    protected $dateFormatter;

    /** @var string $timeZoneInput */
    protected $timeZoneInput;

    /** @var string $timeZoneOutput */
    protected $timeZoneOutput;

    /**
     * Configure date formatter
     *
     * @return void
     */
    protected function configureDateFormatter()
    {
        $this->dateFormatter = new IntlDateFormatter(
            'fr_FR',
            IntlDateFormatter::FULL,
            IntlDateFormatter::FULL,
            $this->timeZoneOutput,
            IntlDateFormatter::GREGORIAN
        );
    }

    /**
     * Get formatted date as string
     *
     * @param string $field
     * @param string $pattern
     *
     * @return null|string
     */
    protected function getFormattedDate($field, $pattern): ?string
    {
        $result = null;

        $value = $this->getData($field);

        if (!empty($value)) {
            if (!($value instanceof DateTime)) {
                try {
                    $this->setData($field, new DateTime($value, new DateTimeZone($this->timeZoneInput)));
                } catch (Exception $exception) {
                    // Do nothing
                }
            }

            $this->dateFormatter->setPattern($pattern);
            $result = $this->dateFormatter->format($this->getData($field));
        }

        return $result;
    }
}
