<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-01-26
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Model\Constants;
use Magento\Customer\Api\AddressMetadataInterface as AddressMetadata;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\ModuleDataSetupInterface as ModuleDataSetup;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Framework\Validator\ValidateException;

/**
 * Class InstallCustomerAddressAttributes
 *
 * Installer for customer address attributes
 */
class InstallCustomerAddressAttributes implements DataPatchInterface, PatchRevertableInterface
{
    /** @var ModuleDataSetup $moduleDataSetup */
    protected ModuleDataSetup $moduleDataSetup;

    /** @var CustomerSetupFactory $customerSetupFactory */
    protected CustomerSetupFactory $customerSetupFactory;

    /**
     * InstallCustomerAddressAttributes constructor
     *
     * @param ModuleDataSetup      $moduleDataSetup
     * @param CustomerSetupFactory $customerSetupFactory
     */
    public function __construct(ModuleDataSetup $moduleDataSetup, CustomerSetupFactory $customerSetupFactory)
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->customerSetupFactory = $customerSetupFactory;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     * @throws ValidateException
     */
    public function apply()
    {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $customerSetup->addAttribute(
            AddressMetadata::ENTITY_TYPE_ADDRESS,
            Constants::ATTRIBUTE_ADDRESS_ALIAS_CODE,
            [
                'label'    => 'Fastmag Alias',
                'required' => false,
                'position' => 1001,
                'system'   => false,
                'visible'  => false
            ]
        );

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $customerSetup->removeAttribute(
            AddressMetadata::ENTITY_TYPE_ADDRESS,
            Constants::ATTRIBUTE_ADDRESS_ALIAS_CODE
        );
    }
}
